/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.property.AbstractSingleValue;
import ch.nolix.systemapi.element.base.IElement;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MutableOptionalValue<V>
extends AbstractSingleValue<V> {
    public MutableOptionalValue(String name, Consumer<V> setterMethod, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name, setterMethod, valueCreator, specificationCreator);
    }

    public static MutableOptionalValue<Boolean> forBoolean(String name, Consumer<Boolean> setterMethod) {
        return new MutableOptionalValue<Boolean>(name, setterMethod, INode::getSingleChildNodeAsBoolean, Node::withChildNode);
    }

    public static <E extends IElement> MutableOptionalValue<E> forElement(String name, Consumer<E> setterMethod, Function<INode<?>, E> valueCreator) {
        return new MutableOptionalValue<IElement>(name, setterMethod, valueCreator, IElement::getSpecification);
    }

    public static MutableOptionalValue<Integer> forInt(String name, Consumer<Integer> setterMethod) {
        return new MutableOptionalValue<Integer>(name, setterMethod, INode::getSingleChildNodeAsInt, Node::withChildNode);
    }

    public static MutableOptionalValue<String> forString(String name, Consumer<String> setterMethod) {
        return new MutableOptionalValue<String>(name, setterMethod, s -> s.getStoredSingleChildNode().getHeaderOrEmptyString(), s -> {
            if (s.isEmpty()) {
                return Node.EMPTY_NODE;
            }
            return Node.withChildNode(s, new String[0]);
        });
    }

    public void clear() {
        this.internalClear();
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

