/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.document.node.Node;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.property.AbstractSingleValue;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MutableValue<V>
extends AbstractSingleValue<V> {
    public MutableValue(String name, V defaultValue, Consumer<V> setterMethod, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        super(name, setterMethod, valueCreator, specificationCreator);
        this.setValue(defaultValue);
    }

    public static MutableValue<Boolean> forBoolean(String name, boolean defaultValue, Consumer<Boolean> setterMethod) {
        return new MutableValue<Boolean>(name, defaultValue, setterMethod, INode::getSingleChildNodeAsBoolean, Node::withChildNode);
    }

    public static MutableValue<Double> forDouble(String name, double defaultValue, Consumer<Double> setterMethod) {
        return new MutableValue<Double>(name, defaultValue, setterMethod, INode::getSingleChildNodeAsDouble, Node::withChildNode);
    }

    public static MutableValue<Integer> forInt(String name, int defaultValue, Consumer<Integer> setterMethod) {
        return new MutableValue<Integer>(name, defaultValue, setterMethod, INode::getSingleChildNodeAsInt, Node::withChildNode);
    }

    public static MutableValue<String> forString(String name, String defaultValue, Consumer<String> setterMethod) {
        return new MutableValue<String>(name, defaultValue, setterMethod, s -> s.getStoredSingleChildNode().getHeaderOrEmptyString(), s -> {
            if (s.isEmpty()) {
                return Node.EMPTY_NODE;
            }
            return Node.withChildNode(s, new String[0]);
        });
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

