/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.graphic.image;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.matrix.Matrix;
import ch.nolix.core.container.matrix.MatrixRow;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.environment.runningjar.RunningJar;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.matrix.IMatrix;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.element.mutableelement.AbstractMutableElement;
import ch.nolix.system.element.property.MutableSpecificationValueExtractor;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.graphic.image.BufferedImageCreator;
import ch.nolix.system.graphic.image.Image;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.graphic.image.IImage;
import ch.nolix.systemapi.graphic.image.IMutableImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public final class MutableImage
extends AbstractMutableElement
implements IMutableImage<MutableImage> {
    private static final String PIXEL_ARRAY_HEADER = "PixelArray";
    private static final String JPG_STRING = "JPGString";
    private final Matrix<IColor> pixels;
    private final MutableSpecificationValueExtractor pixelsExtractor = new MutableSpecificationValueExtractor("PixelArray", this::setPixelArray, this::getPixelArraySpecification);
    private String nullableBase64PngString;
    private String nullableBase64JpgString;
    private Node nullablePixelArraySpecification;
    private BufferedImage nullableBufferedImage;

    private MutableImage(Matrix<IColor> pixels) {
        this.pixels = pixels;
    }

    public static MutableImage fromAnyImage(IImage image) {
        return MutableImage.withPixels(image.getPixels());
    }

    public static MutableImage fromBytes(byte[] bytes) {
        BufferedImage bufferedImage = BufferedImageCreator.createBufferedImageFromBytes(bytes);
        return MutableImage.fromBufferedImage(bufferedImage);
    }

    public static MutableImage fromBufferedImage(BufferedImage bufferedImage) {
        MutableImage image = MutableImage.withWidthAndHeightAndWhiteColor(bufferedImage.getWidth(), bufferedImage.getHeight());
        int i = 1;
        while (i <= image.getWidth()) {
            int j = 1;
            while (j <= image.getHeight()) {
                int pixel = bufferedImage.getRGB(i - 1, j - 1);
                image.setPixel(i, j, Color.withRedValueAndGreenValueAndBlueValueAndAlphaValue(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF, pixel >> 24 & 0xFF));
                ++j;
            }
            ++i;
        }
        return image;
    }

    public static MutableImage fromFile(String filePath) {
        BufferedImage bufferedImage = BufferedImageCreator.createBufferedImageFromFileWithFilePath(filePath);
        return MutableImage.fromBufferedImage(bufferedImage);
    }

    public static MutableImage fromResource(String path) {
        return MutableImage.fromBytes(RunningJar.getResourceAsBytes(path));
    }

    public static MutableImage fromSpecification(INode<?> specification) {
        if (specification.containsChildNodeWithHeader(JPG_STRING)) {
            String lJPGString = specification.getStoredFirstChildNodeWithHeader(JPG_STRING).getSingleChildNodeHeader();
            return MutableImage.fromBytes(Base64.getDecoder().decode(lJPGString.substring(lJPGString.indexOf(44) + 1)));
        }
        Object pixelArraySpecification = specification.getStoredFirstChildNodeWithHeader(PIXEL_ARRAY_HEADER);
        int width = pixelArraySpecification.getStoredFirstChildNodeWithHeader("Width").getSingleChildNodeAsInt();
        int height = pixelArraySpecification.getStoredFirstChildNodeWithHeader("Height").getSingleChildNodeAsInt();
        Object pixelArray = pixelArraySpecification.getStoredFirstChildNodeThat(a -> a.hasHeader("Pixels"));
        MutableImage image = MutableImage.withWidthAndHeightAndWhiteColor(width, height);
        image.setPixelArray((INode<?>)pixelArray);
        return image;
    }

    public static MutableImage fromString(String string) {
        return MutableImage.fromSpecification(Node.fromString(string));
    }

    public static MutableImage withPixels(IMatrix<IColor> pixels) {
        return new MutableImage(Matrix.fromMatrix(pixels));
    }

    public static MutableImage withWidthAndHeightAndColor(int width, int height, IColor color) {
        Validator.assertThat(width).thatIsNamed("width").isPositive();
        Validator.assertThat(height).thatIsNamed("height").isPositive();
        Validator.assertThat(color).thatIsNamed(Color.class).isNotNull();
        Matrix<IColor> pixels = Matrix.createEmpty();
        if (width > 0 && height > 0) {
            Color[] row = new Color[width];
            int i = 0;
            while (i < width) {
                row[i] = Color.fromColor(color);
                ++i;
            }
            i = 1;
            while (i <= height) {
                pixels.addRow((Iterable<IColor>)ContainerView.forArray(row));
                ++i;
            }
        }
        return new MutableImage(pixels);
    }

    public static MutableImage withWidthAndHeightAndWhiteColor(int width, int height) {
        return MutableImage.withWidthAndHeightAndColor(width, height, X11ColorCatalog.WHITE);
    }

    @Override
    public IColor getBottomLeftPixel() {
        return this.getPixel(1, this.getHeight());
    }

    @Override
    public IColor getBottomRightPixel() {
        return this.getPixel(this.getWidth(), this.getHeight());
    }

    @Override
    public MutableImage getCopy() {
        return new MutableImage(this.pixels.getCopy());
    }

    @Override
    public int getHeight() {
        return this.pixels.getRowCount();
    }

    @Override
    public IColor getPixel(int xPosition, int yPosition) {
        return this.pixels.getStoredAtOneBasedRowIndexAndColumnIndex(yPosition, xPosition);
    }

    @Override
    public int getPixelCount() {
        return this.pixels.getCount();
    }

    public Matrix<IColor> getPixels() {
        return this.pixels.getCopy();
    }

    public MutableImage getSection(int xPosition, int yPosition, int width, int height) {
        Validator.assertThat(xPosition).thatIsNamed("x-position").isPositive();
        Validator.assertThat(xPosition).thatIsNamed("y-position").isPositive();
        Validator.assertThat(width).thatIsNamed("width").isBetween(0, this.getWidth() - xPosition + 1);
        Validator.assertThat(height).thatIsNamed("width").isBetween(0, this.getHeight() - yPosition + 1);
        MutableImage section = MutableImage.withWidthAndHeightAndWhiteColor(width, height);
        int i = 1;
        while (i <= width) {
            int j = 1;
            while (j <= height) {
                section.setPixel(i, j, this.getPixel(xPosition + i - 1, yPosition + j - 1));
                ++j;
            }
            ++i;
        }
        return section;
    }

    @Override
    public IColor getTopLeftPixel() {
        return this.getPixel(1, 1);
    }

    @Override
    public IColor getTopRightPixel() {
        return this.getPixel(this.getWidth(), 1);
    }

    @Override
    public int getWidth() {
        return this.pixels.getColumnCount();
    }

    @Override
    public void reset() {
        this.removeGeneratedOutputs();
        int pixelCount = this.getPixelCount();
        int i = 1;
        while (i <= pixelCount) {
            this.pixels.setAt(i, X11ColorCatalog.WHITE);
            ++i;
        }
    }

    @Override
    public MutableImage setPixel(int xPosition, int yPosition, IColor color) {
        this.removeGeneratedOutputs();
        this.pixels.setAtOneBasedRowIndexAndColumnIndex(yPosition, xPosition, color);
        return this;
    }

    public void setPixelArray(INode<?> pixelArray) {
        IContainer<?> pixelSpecifications = pixelArray.getStoredChildNodes();
        Validator.assertThat(pixelSpecifications.getCount()).thatIsNamed("number of pixels").isEqualTo(this.getPixelCount());
        this.removeGeneratedOutputs();
        int index = 1;
        for (INode p : pixelSpecifications) {
            Color pixel = Color.fromString(p.getHeader());
            this.pixels.setAt(index, pixel);
            ++index;
        }
    }

    public void setPixelArray(IContainer<IColor> pixelArray) {
        Validator.assertThat(pixelArray.getCount()).thatIsNamed("number of pixels").isEqualTo(this.getPixelCount());
        this.removeGeneratedOutputs();
        int index = 1;
        for (IColor p : pixelArray) {
            this.pixels.setAt(index, p);
            ++index;
        }
    }

    @Override
    public String toBase64Jpg() {
        if (this.nullableBase64JpgString == null) {
            this.nullableBase64JpgString = this.generateBase64JpgString();
        }
        return this.nullableBase64JpgString;
    }

    @Override
    public String toBase64Png() {
        if (this.nullableBase64PngString == null) {
            this.nullableBase64PngString = this.generateBase64PngString();
        }
        return this.nullableBase64PngString;
    }

    @Override
    public BufferedImage toBufferedImage() {
        if (this.nullableBufferedImage == null) {
            this.nullableBufferedImage = this.generateBufferedImage();
        }
        return this.nullableBufferedImage;
    }

    @Override
    public Image toImmutableImage() {
        return Image.withPixels(this.pixels);
    }

    @Override
    public byte[] toJpg() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        imageWriteParam.setCompressionMode(2);
        imageWriteParam.setCompressionQuality(1.0f);
        try {
            imageWriter.setOutput(ImageIO.createImageOutputStream(byteArrayOutputStream));
            imageWriter.write(null, new IIOImage(this.generateJpgBufferedImage(), null, null), imageWriteParam);
            imageWriter.dispose();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public MutableImage toLeftRotatedImage() {
        return new MutableImage(this.pixels.toLeftRotatedMatrix());
    }

    @Override
    public byte[] toPng() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.toBufferedImage(), "png", byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public MutableImage toRepeatedImage(int width, int height) {
        MutableImage image = MutableImage.withWidthAndHeightAndWhiteColor(width, height);
        int sourceWidth = this.getWidth();
        int sourceHeight = this.getHeight();
        int x = 1;
        while (x <= width) {
            int y = 1;
            while (y <= height) {
                image.setPixel(x, y, this.getPixel((x - 1) % sourceWidth + 1, (y - 1) % sourceHeight + 1));
                ++y;
            }
            ++x;
        }
        return image;
    }

    public MutableImage toRightRotatedImage() {
        return new MutableImage(this.pixels.toRightRotatedMatrix());
    }

    public MutableImage toScaledImage(double factor) {
        Validator.assertThat(factor).thatIsNamed("factor").isPositive();
        return this.toScaledImage(factor, factor);
    }

    public MutableImage toScaledImage(double widthFactor, double heightFactor) {
        Validator.assertThat(widthFactor).thatIsNamed("width factor").isPositive();
        Validator.assertThat(heightFactor).thatIsNamed("height factor").isPositive();
        MutableImage image = MutableImage.withWidthAndHeightAndWhiteColor((int)(widthFactor * (double)this.getWidth()), (int)(heightFactor * (double)this.getHeight()));
        double reziprocalWidthFactor = 1.0 / widthFactor;
        double reziprocalHeightFactor = 1.0 / heightFactor;
        int[] sourceYs = new int[image.getHeight() + 1];
        int i = 1;
        while (i <= image.getHeight()) {
            sourceYs[i] = (int)((double)(i - 1) * reziprocalHeightFactor) + 1;
            ++i;
        }
        int x = 1;
        while (x <= image.getWidth()) {
            int sourceX = (int)((double)(x - 1) * reziprocalWidthFactor) + 1;
            int y = 1;
            while (y <= image.getHeight()) {
                int sourceY = sourceYs[y];
                image.setPixel(x, y, this.getPixel(sourceX, sourceY));
                ++y;
            }
            ++x;
        }
        return image;
    }

    @Override
    public IMutableImage<?> withAlphaValue(double alphaValue) {
        Matrix<IColor> localPixels = Matrix.createEmpty();
        for (MatrixRow matrixRow : this.pixels.getRows()) {
            localPixels.addRow((Iterable<IColor>)matrixRow.getViewOf(p -> p.withFloatingPointAlphaValue(alphaValue)));
        }
        return new MutableImage(localPixels);
    }

    @Override
    public IMutableImage<?> withWidthAndHeight(int width, int height) {
        return this.toScaledImage((double)width / (double)this.getWidth(), (double)height / (double)this.getHeight());
    }

    private String generateBase64JpgString() {
        return Base64.getEncoder().encodeToString(this.toJpg());
    }

    private String generateBase64PngString() {
        return Base64.getEncoder().encodeToString(this.toPng());
    }

    private BufferedImage generateBufferedImage() {
        BufferedImage lBufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 7);
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                IColor pixel = this.pixels.getStoredAtOneBasedRowIndexAndColumnIndex(y + 1, x + 1);
                lBufferedImage.setRGB(x, y, pixel.toAlphaRedGreenBlueInt());
                ++x;
            }
            ++y;
        }
        return lBufferedImage;
    }

    private BufferedImage generateJpgBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        int y = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                IColor pixel = this.pixels.getStoredAtOneBasedRowIndexAndColumnIndex(y + 1, x + 1);
                bufferedImage.setRGB(x, y, pixel.toAlphaRedGreenBlueInt());
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }

    private Node generatePixelArraySpecification() {
        return Node.withHeaderAndChildNode(PIXEL_ARRAY_HEADER, Node.withHeaderAndChildNode("Width", this.getWidth()), Node.withHeaderAndChildNode("Height", this.getHeight()), Node.withHeaderAndChildNodes("Pixels", this.pixels.getViewOf(p -> Node.withHeader(p.toHexadecimalStringWithAlphaValue()))));
    }

    private Node getPixelArraySpecification() {
        if (this.nullablePixelArraySpecification == null) {
            this.nullablePixelArraySpecification = this.generatePixelArraySpecification();
        }
        return this.nullablePixelArraySpecification;
    }

    private void removeGeneratedOutputs() {
        this.nullableBase64JpgString = null;
        this.nullableBase64PngString = null;
        this.nullablePixelArraySpecification = null;
        this.nullableBufferedImage = null;
    }
}

