/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.midschema.adapter;

import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.resourcecontrol.closecontroller.GroupCloseable;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.midschema.adapter.ISchemaReader;
import ch.nolix.systemapi.midschema.adapter.ISchemaWriter;
import ch.nolix.systemapi.midschema.databaseinitializer.IDatabaseInitializer;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.model.TableDto;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.time.moment.ITime;
import java.util.function.Supplier;

public abstract class AbstractSchemaAdapter
implements ISchemaAdapter {
    private final ICloseController closeController = CloseController.forElement(this);
    private final ISchemaReader schemaReader;
    private final ISchemaWriter schemaWriter;

    protected AbstractSchemaAdapter(IDatabaseInitializer databaseInitializer, Supplier<ISchemaReader> schemaReaderCreator, Supplier<ISchemaWriter> schemaWriterCreator) {
        databaseInitializer.initializeDatabaseIfNotInitialized();
        this.schemaReader = schemaReaderCreator.get();
        this.schemaWriter = schemaWriterCreator.get();
        this.createCloseDependencyTo(this.schemaReader);
        this.createCloseDependencyTo(this.schemaWriter);
    }

    @Override
    public final void addColumn(TableIdentification table, ColumnDto column) {
        this.schemaWriter.addColumn(table, column);
    }

    @Override
    public final void addTable(TableDto table) {
        this.schemaWriter.addTable(table);
    }

    @Override
    public final boolean columnIsEmpty(String tableName, String columnName) {
        return this.schemaReader.columnIsEmpty(tableName, columnName);
    }

    @Override
    public final void createCloseDependencyTo(GroupCloseable element) {
        ISchemaAdapter.super.createCloseDependencyTo(element);
    }

    @Override
    public final void deleteColumn(TableIdentification table, String columnName) {
        this.schemaWriter.deleteColumn(table, columnName);
    }

    @Override
    public final void deleteTable(String tableName) {
        this.schemaWriter.deleteTable(tableName);
    }

    @Override
    public final ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public final int getSaveCount() {
        return this.schemaWriter.getSaveCount();
    }

    @Override
    public final int getTableCount() {
        return this.schemaReader.getTableCount();
    }

    @Override
    public final boolean hasChanges() {
        return this.schemaWriter.hasChanges();
    }

    @Override
    public final ITime getSchemaTimestamp() {
        return this.schemaReader.getSchemaTimestamp();
    }

    @Override
    public final TableDto loadTable(String tableName) {
        return this.schemaReader.loadTable(tableName);
    }

    @Override
    public final IContainer<TableDto> loadTables() {
        return this.schemaReader.loadTables();
    }

    @Override
    public final void noteClose() {
    }

    @Override
    public final void reset() {
        this.schemaWriter.reset();
    }

    @Override
    public final void saveChanges() {
        this.schemaWriter.saveChanges();
    }

    @Override
    public final void renameColumn(String tableName, String columnName, String newColumnName) {
        this.schemaWriter.renameColumn(tableName, columnName, newColumnName);
    }

    @Override
    public final void renameTable(String tableName, String newTableName) {
        this.schemaWriter.renameTable(tableName, newTableName);
    }

    @Override
    public final void setColumnModel(TableIdentification table, ColumnIdentification column, FieldType fieldType, DataType dataType, IContainer<String> referenceableTableIds, IContainer<String> backReferenceableColumnIds) {
        this.schemaWriter.setColumnModel(table, column, fieldType, dataType, referenceableTableIds, backReferenceableColumnIds);
    }
}

