/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.datawriter;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.midschemaview.modelsearcher.DatabaseViewSearcherForDatabaseView;
import ch.nolix.system.nodemiddata.datawriter.ExecutiveDataWriter;
import ch.nolix.system.nodemiddata.nodemapper.EntityIndexNodeMapper;
import ch.nolix.system.nodemiddata.nodemapper.EntityNodeMapper;
import ch.nolix.systemapi.middata.adapter.IDataWriter;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.EntityDeletionDto;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDeletionDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.middata.model.MultiValueEntryDto;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.DatabaseViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.midschemaview.modelsearcher.IDatabaseViewSearcherForDatabaseView;
import ch.nolix.systemapi.nodemiddata.nodemapper.IEntityIndexNodeMapper;
import ch.nolix.systemapi.nodemiddata.nodemapper.IEntityNodeMapper;
import ch.nolix.systemapi.time.moment.ITime;

public final class DataWriter
implements IDataWriter {
    public static final int INITIAL_ENTITY_SAVE_STAMP = 0;
    private static final IEntityNodeMapper ENTITY_NODE_MAPPER = new EntityNodeMapper();
    private static final IEntityIndexNodeMapper ENTITY_INDEXES_NODE_MAPPER = new EntityIndexNodeMapper();
    private final ICloseController closeController = CloseController.forElement(this);
    private final IDatabaseViewSearcherForDatabaseView databaseViewSearcherForDatabaseView;
    private final ExecutiveDataWriter executiveDataWriter;

    private DataWriter(IMutableNode<?> nodeDatabase, DatabaseViewDto databaseView) {
        this.databaseViewSearcherForDatabaseView = DatabaseViewSearcherForDatabaseView.forDatabaseView(databaseView);
        this.executiveDataWriter = ExecutiveDataWriter.forNodeDatabase(nodeDatabase);
    }

    public static DataWriter forNodeDatabaseAndDatabaseView(IMutableNode<?> nodeDatabase, DatabaseViewDto databaseView) {
        return new DataWriter(nodeDatabase, databaseView);
    }

    @Override
    public void clearMultiReference(String tableName, String entityId, String multiReferenceColumnName) {
        ColumnViewDto multiReferenceColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnName(tableName, multiReferenceColumnName);
        int multiReferencedColumnOneBasedOrdinalIndex = multiReferenceColumnView.oneBasedOrdinalIndex();
        this.executiveDataWriter.clearMultiReference(tableName, entityId, multiReferencedColumnOneBasedOrdinalIndex);
    }

    @Override
    public void clearMultiValue(String tableName, String entityId, String multiValueColumnName) {
        ColumnViewDto multiValueColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnName(tableName, multiValueColumnName);
        int multiValueColumnOneBasedOrdinalIndex = multiValueColumnView.oneBasedOrdinalIndex();
        this.executiveDataWriter.clearMultiValue(tableName, entityId, multiValueColumnOneBasedOrdinalIndex);
    }

    @Override
    public void deleteEntity(String tableName, EntityDeletionDto entity) {
        String entityId = entity.id();
        String entitySaveStamp = entity.saveStamp();
        this.executiveDataWriter.deleteEntity(tableName, entityId, entitySaveStamp);
    }

    @Override
    public void deleteMultiBackReferenceEntry(MultiBackReferenceEntryDeletionDto multiBackReferenceEntry) {
        String tableName = multiBackReferenceEntry.tableName();
        String entityId = multiBackReferenceEntry.entityId();
        String multiBackReferenceColumnId = multiBackReferenceEntry.multiBackReferenceColumnId();
        ColumnViewDto multiBackReferenceColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnId(tableName, multiBackReferenceColumnId);
        int multiBackReferenceColumnOneBasedOrdinalIndex = multiBackReferenceColumnView.oneBasedOrdinalIndex();
        String backReferencedEntityId = multiBackReferenceEntry.backReferencedEntityId();
        this.executiveDataWriter.deleteMultiBackReferenceEntry(tableName, entityId, multiBackReferenceColumnOneBasedOrdinalIndex, backReferencedEntityId);
    }

    @Override
    public void deleteMultiReferenceEntry(MultiReferenceEntryDeletionDto multiReferenceEntry) {
        String tableName = multiReferenceEntry.tableName();
        String entityId = multiReferenceEntry.entityId();
        String multiReferenceColumnId = multiReferenceEntry.multiReferenceColumnId();
        ColumnViewDto multiReferenceColumnNameView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnId(tableName, multiReferenceColumnId);
        int multiReferencedColumnOneBasedOrdinalIndex = multiReferenceColumnNameView.oneBasedOrdinalIndex();
        String referencedEntityId = multiReferenceEntry.referencedEntityId();
        this.executiveDataWriter.deleteMultiReferenceEntry(tableName, entityId, multiReferencedColumnOneBasedOrdinalIndex, referencedEntityId);
    }

    @Override
    public void deleteMultiValueEntry(MultiValueEntryDto multiValueEntry) {
        String tableName = multiValueEntry.tableName();
        String entityId = multiValueEntry.entityId();
        String multiValueColumnId = multiValueEntry.multiValueColumnId();
        ColumnViewDto multiValueColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnId(tableName, multiValueColumnId);
        int multiValueColumnOneBasedOrdinalIndex = multiValueColumnView.oneBasedOrdinalIndex();
        String value = multiValueEntry.value();
        this.executiveDataWriter.deleteMultiValueEntry(tableName, entityId, multiValueColumnOneBasedOrdinalIndex, value);
    }

    @Override
    public void expectSchemaTimestamp(ITime schemaTimestamp) {
        this.executiveDataWriter.expectSchemaTimestamp(schemaTimestamp);
    }

    @Override
    public void expectTableContainsEntity(String tableName, String entityId) {
        this.executiveDataWriter.expectTableContainsEntity(tableName, entityId);
    }

    @Override
    public int getSaveCount() {
        return this.executiveDataWriter.getSaveCount();
    }

    @Override
    public boolean hasChanges() {
        return this.executiveDataWriter.hasUpdates();
    }

    @Override
    public void insertEntity(String tableName, EntityCreationDto entity) {
        TableViewDto tableView = this.databaseViewSearcherForDatabaseView.getTableViewByTableName(tableName);
        String tableId = tableView.id();
        String entityId = entity.id();
        INode<?> entityIndexNode = ENTITY_INDEXES_NODE_MAPPER.mapEntityCreationDtoToEntityIndexNode(entity, tableId);
        boolean saveStamp = false;
        INode<?> entityNode = ENTITY_NODE_MAPPER.mapEntityCreationDtoToEntityNode(entity, tableView, 0L);
        this.executiveDataWriter.insertEntity(tableName, entityId, entityIndexNode, entityNode);
    }

    @Override
    public void insertMultiBackReferenceEntry(MultiBackReferenceEntryDto multiBackReferenceEntry) {
        String tableName = multiBackReferenceEntry.tableName();
        String entityId = multiBackReferenceEntry.entityId();
        String multiBackReferenceColumnId = multiBackReferenceEntry.multiBackReferenceColumnId();
        ColumnViewDto multiBackReferenceColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnId(tableName, multiBackReferenceColumnId);
        int multiBackReferenceColumnOneBasedOrdinalIndex = multiBackReferenceColumnView.oneBasedOrdinalIndex();
        String backReferencedEntityId = multiBackReferenceEntry.backReferencedEntityId();
        String backReferencedEntityTableId = multiBackReferenceEntry.backReferencedEntityTableId();
        Node multiBackReferenceEntryNode = Node.withChildNode(backReferencedEntityId, backReferencedEntityTableId);
        this.executiveDataWriter.insertMultiBackReferenceEntry(tableName, entityId, multiBackReferenceColumnOneBasedOrdinalIndex, multiBackReferenceEntryNode);
    }

    @Override
    public void insertMultiReferenceEntry(MultiReferenceEntryDto multiReferenceEntry) {
        String tableName = multiReferenceEntry.tableName();
        String entityId = multiReferenceEntry.entityId();
        String multiReferenceColumnId = multiReferenceEntry.multiReferenceColumnId();
        ColumnViewDto multiReferenceColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnId(tableName, multiReferenceColumnId);
        int multiReferenceColumnOneBasedOrdinalIndex = multiReferenceColumnView.oneBasedOrdinalIndex();
        Node multiReferenceEntryNode = Node.withChildNode(multiReferenceEntry.referencedEntityId(), multiReferenceEntry.referencedEntityTableId());
        this.executiveDataWriter.insertMultiReferenceEntry(tableName, entityId, multiReferenceColumnOneBasedOrdinalIndex, multiReferenceEntryNode);
    }

    @Override
    public void insertMultiValueEntry(MultiValueEntryDto multiValueEntry) {
        String tableName = multiValueEntry.tableName();
        String entityId = multiValueEntry.entityId();
        String multiValueColumnId = multiValueEntry.multiValueColumnId();
        ColumnViewDto multiValueColumnView = this.databaseViewSearcherForDatabaseView.getColumnViewByTableNameAndColumnId(tableName, multiValueColumnId);
        int multiValueColumnOneBasedOrdinalIndex = multiValueColumnView.oneBasedOrdinalIndex();
        String value = multiValueEntry.value();
        this.executiveDataWriter.insertMultiValueEntry(tableName, entityId, multiValueColumnOneBasedOrdinalIndex, value);
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public void noteClose() {
    }

    @Override
    public void reset() {
        this.executiveDataWriter.reset();
    }

    @Override
    public void saveChanges() {
        this.executiveDataWriter.saveChangesAndReset();
    }

    @Override
    public void updateEntity(String tableName, EntityUpdateDto entityUpdate) {
        TableViewDto tableView = this.databaseViewSearcherForDatabaseView.getTableViewByTableName(tableName);
        this.executiveDataWriter.updateEntity(entityUpdate, tableView);
    }
}

