/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.modelmapper;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.datamodel.fieldproperty.DataType;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.middata.valuemapper.ValueMapper;
import ch.nolix.systemapi.middata.model.FieldDto;
import ch.nolix.systemapi.middata.valuemapper.IValueMapper;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.nodemiddata.modelmapper.IContentFieldDtoMapper;

public final class ContentFieldDtoMapper
implements IContentFieldDtoMapper {
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();

    @Override
    public FieldDto mapContentFieldNodeToContentFieldDto(INode<?> contentFieldNode, ColumnViewDto columnView) {
        String columnName = columnView.name();
        FieldType fieldType = columnView.fieldType();
        DataType dataType = columnView.dataType();
        switch (fieldType) {
            case VALUE_FIELD: {
                String valueAsString = contentFieldNode.getHeader();
                Object value = VALUE_MAPPER.mapStringToValue(valueAsString, dataType);
                return new FieldDto(columnName, value, null);
            }
            case REFERENCE: 
            case BACK_REFERENCE: {
                String valueAsString2 = contentFieldNode.getStoredChildNodeAtOneBasedIndex(1).getHeader();
                Object value2 = VALUE_MAPPER.mapStringToValue(valueAsString2, dataType);
                String additionalValue2 = contentFieldNode.getStoredChildNodeAtOneBasedIndex(2).getHeader();
                return new FieldDto(columnName, value2, additionalValue2);
            }
            case OPTIONAL_VALUE_FIELD: {
                if (contentFieldNode.hasHeader()) {
                    String valueAsString3 = contentFieldNode.getHeader();
                    Object value3 = VALUE_MAPPER.mapStringToValue(valueAsString3, dataType);
                    return new FieldDto(columnName, value3, null);
                }
                return new FieldDto(columnName, null, null);
            }
            case OPTIONAL_REFERENCE: 
            case OPTIONAL_BACK_REFERENCE: {
                if (contentFieldNode.containsChildNodes()) {
                    String valueAsString4 = contentFieldNode.getStoredChildNodeAtOneBasedIndex(1).getHeader();
                    Object value4 = VALUE_MAPPER.mapStringToValue(valueAsString4, dataType);
                    String additionalValue4 = contentFieldNode.getStoredChildNodeAtOneBasedIndex(2).getHeader();
                    return new FieldDto(columnName, value4, additionalValue4);
                }
                return new FieldDto(columnName, null, null);
            }
            case MULTI_VALUE_FIELD: 
            case MULTI_REFERENCE: 
            case MULTI_BACK_REFERENCE: {
                return new FieldDto(columnName, null, null);
            }
        }
        throw InvalidArgumentException.forArgument((Object)fieldType);
    }

    @Override
    public IContainer<FieldDto> mapEntityNodeToContentFieldDtos(IMutableNode<?> entityNode, TableViewDto tableView) {
        LinkedList<FieldDto> contentFields = LinkedList.createEmpty();
        for (ColumnViewDto c : tableView.columnViews()) {
            IMutableNode contentFieldNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(c.oneBasedOrdinalIndex());
            FieldDto contentFieldDto = this.mapContentFieldNodeToContentFieldDto(contentFieldNode, c);
            contentFields.addAtEnd(contentFieldDto);
        }
        return contentFields;
    }
}

