/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.databaseinitializer;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.system.midschema.databaseinitializer.AbstractDatabaseInitializer;
import ch.nolix.system.nodemidschema.databaseinitializer.DatabaseComponentCreator;
import ch.nolix.system.nodemidschema.databaseinitializer.DatabaseStateAnalyser;
import ch.nolix.systemapi.midschema.databaseinitializer.DatabaseState;
import ch.nolix.systemapi.nodemidschema.databaseinitializer.IDatabaseComponentCreator;
import ch.nolix.systemapi.nodemidschema.databaseinitializer.IDatabaseStateAnalyser;
import ch.nolix.systemapi.time.moment.ITime;

public final class DatabaseInitializer
extends AbstractDatabaseInitializer {
    private static final IDatabaseStateAnalyser DATABASE_STATE_ANALYSER = new DatabaseStateAnalyser();
    private static final IDatabaseComponentCreator DATABASE_COMPONENT_CREATOR = new DatabaseComponentCreator();
    private final String databaseName;
    private final IMutableNode<?> nodeDatabase;

    private DatabaseInitializer(String databaseName, IMutableNode<?> nodeDatabase) {
        Validator.assertThat(databaseName).thatIsNamed("database name").isNotBlank();
        Validator.assertThat(nodeDatabase).thatIsNamed("node database").isNotNull();
        this.databaseName = databaseName;
        this.nodeDatabase = nodeDatabase;
    }

    public static DatabaseInitializer forDatabaseNameAndNodeDatabase(String databaseName, IMutableNode<?> nodeDatabase) {
        return new DatabaseInitializer(databaseName, nodeDatabase);
    }

    @Override
    public DatabaseState getDatabaseState() {
        return DATABASE_STATE_ANALYSER.getStateOfNodeDatabase(this.nodeDatabase);
    }

    @Override
    protected void initializeDatabaseWithInitialSchemaTimestamp(ITime initialSchemaTimeStamp) {
        IMutableNode<?> databasePropertiesNode = DATABASE_COMPONENT_CREATOR.createDatabasePropertiesNodeWithDatabaseNameAndInitialSchemaTimeStamp(this.databaseName, initialSchemaTimeStamp);
        IMutableNode<?> entityIndexesNodes = DATABASE_COMPONENT_CREATOR.createEntityIndexesNode();
        ((IMutableNode)this.nodeDatabase.setHeader("Database")).addChildNode(databasePropertiesNode, entityIndexesNodes);
    }
}

