/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.nodesearcher;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.system.nodemidschema.nodesearcher.ColumnNodeSearcher;
import ch.nolix.systemapi.midschema.databasestructure.FixDatabasePropertyCatalogue;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IColumnNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.ITableNodeSearcher;

public final class TableNodeSearcher
implements ITableNodeSearcher {
    private static final IColumnNodeSearcher COLUMN_NODE_SEARCHER = new ColumnNodeSearcher();

    @Override
    public int getOneBasedIndexOfColumnInTableNodeByColumnName(IMutableNode<?> tableNode, String columnName) {
        int oneBasedColumnIndex = FixDatabasePropertyCatalogue.NUMBER_OF_ENTITY_META_FIELDS + 1;
        for (IMutableNode iMutableNode : this.getStoredColumnNodesFromTableNode(tableNode)) {
            if (COLUMN_NODE_SEARCHER.getColumnNameFromColumnNode(iMutableNode).equals(columnName)) {
                return oneBasedColumnIndex;
            }
            ++oneBasedColumnIndex;
        }
        throw InvalidArgumentException.forArgumentAndArgumentName(columnName, "column name");
    }

    @Override
    public IMutableNode<?> getStoredColumnNodeFromTableNodeByColumnId(IMutableNode<?> tableNode, String columnId) {
        IContainer<IMutableNode<?>> columnNodes = this.getStoredColumnNodesFromTableNode(tableNode);
        return columnNodes.getStoredFirst(c -> ((IMutableNode)COLUMN_NODE_SEARCHER.getStoredIdNodeFromColumnNode((IMutableNode<?>)c).getStoredSingleChildNode()).hasHeader(columnId));
    }

    @Override
    public IMutableNode<?> getStoredColumnNodeFromTableNodeByColumnName(IMutableNode<?> tableNode, String columnName) {
        IContainer<IMutableNode<?>> columnNodes = this.getStoredColumnNodesFromTableNode(tableNode);
        return columnNodes.getStoredFirst(c -> ((IMutableNode)COLUMN_NODE_SEARCHER.getStoredNameNodeFromColumnNode((IMutableNode<?>)c).getStoredSingleChildNode()).hasHeader(columnName));
    }

    @Override
    public IContainer<? extends IMutableNode<?>> getStoredColumnNodesFromTableNode(IMutableNode<?> tableNode) {
        return tableNode.getStoredChildNodesWithHeader("Column");
    }

    @Override
    public IContainer<? extends IMutableNode<?>> getStoredEntityNodesFromTableNode(IMutableNode<?> tableNode) {
        return tableNode.getStoredChildNodesWithHeader("Entity");
    }

    @Override
    public IMutableNode<?> getStoredIdNodeFromTableNode(IMutableNode<?> tableNode) {
        return (IMutableNode)tableNode.getStoredFirstChildNodeWithHeader("Id");
    }

    @Override
    public IMutableNode<?> getStoredNameNodeFromTableNode(IMutableNode<?> tableNode) {
        return (IMutableNode)tableNode.getStoredFirstChildNodeWithHeader("Name");
    }

    @Override
    public String getTableIdFromTableNode(IMutableNode<?> tableNode) {
        IMutableNode<?> idNode = this.getStoredIdNodeFromTableNode(tableNode);
        return idNode.getSingleChildNodeHeader();
    }

    @Override
    public String getTableNameFromTableNode(IMutableNode<?> tableNode) {
        IMutableNode<?> nameNode = this.getStoredNameNodeFromTableNode(tableNode);
        return nameNode.getSingleChildNodeHeader();
    }
}

