/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.MultiBackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class BaseReferenceUpdater {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();

    private BaseReferenceUpdater() {
    }

    public static <E extends IEntity> void ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(IBaseReference baseReference, E entity) {
        Optional<IBaseBackReference> baseBackReference = ENTITY_SEARCHER.getOptionalStoredBaseBackReferenceWhoCanBackReferenceTheBaseReference(entity, baseReference);
        baseBackReference.ifPresent(bbr -> BaseReferenceUpdater.toBaseBackReferenceAddOrSetEntity(bbr, (IEntity)baseReference.getStoredParentEntity()));
    }

    private static void toBaseBackReferenceAddOrSetEntity(IBaseBackReference baseBackReference, IEntity entity) {
        FieldType type = baseBackReference.getType();
        switch (type) {
            case BACK_REFERENCE: {
                BackReference backReference = (BackReference)baseBackReference;
                backReference.setBackReferencedEntityOnly(entity);
                break;
            }
            case OPTIONAL_BACK_REFERENCE: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)baseBackReference;
                optionalBackReference.setBackReferencedEntityOnly(entity);
                break;
            }
            case MULTI_BACK_REFERENCE: {
                MultiBackReference multiBackReference = (MultiBackReference)baseBackReference;
                multiBackReference.internalAddBackReferencedEntity(entity);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)type);
            }
        }
    }
}

