/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.system.objectdata.entitytool.EntityCreator;
import ch.nolix.system.objectdata.entitytool.EntityFiller;
import ch.nolix.systemapi.middata.adapter.IDataReader;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.objectdata.entitytool.IEntityCreator;
import ch.nolix.systemapi.objectdata.entitytool.IEntityFiller;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;

public final class EntityLoader {
    private static final IEntityCreator ENTITY_CREATOR = new EntityCreator();
    private static final IEntityFiller ENTITY_FILLER = new EntityFiller();

    private EntityLoader() {
    }

    public static <E extends IEntity> E loadEntityById(ITable<E> table, String id, IDataReader dataReader) {
        Class<E> entityType = table.getEntityType();
        E entity = ENTITY_CREATOR.createEmptyEntityForEntityType(entityType);
        String tableName = table.getName();
        EntityLoadingDto entityLoadingDto = dataReader.loadEntity(tableName, id);
        entity.internalSetParentTable(table);
        ENTITY_FILLER.fillUpEntityFromEntityLoadingDto((IEntity)entity, entityLoadingDto);
        return entity;
    }
}

