/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.system.objectdata.entitytool.TableNameExtractor;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.system.objectdata.model.AbstractBaseBackReference;
import ch.nolix.system.objectdata.model.MultiBackReferenceEntry;
import ch.nolix.system.objectdata.model.MultiBackReferenceEntryMapper;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.modelexaminer.IDatabaseObjectExaminer;
import ch.nolix.systemapi.middata.model.MultiBackReferenceEntryDto;
import ch.nolix.systemapi.midschema.fieldproperty.FieldType;
import ch.nolix.systemapi.midschema.structure.ColumnIdentification;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.objectdata.entitytool.ITableNameExtractor;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IColumn;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiBackReferenceEntry;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Iterator;

public final class MultiBackReference<E extends IEntity>
extends AbstractBaseBackReference
implements IMultiBackReference<E> {
    private static final ITableNameExtractor TABLE_NAME_EXTRACTOR = new TableNameExtractor();
    private static final IDatabaseObjectExaminer DATABASE_OBJECT_EXAMINER = new DatabaseObjectExaminer();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private boolean loadedAllPersistedBackReferencedEntityIds;
    private final ILinkedList<MultiBackReferenceEntry<E>> localEntries = LinkedList.createEmpty();

    private MultiBackReference(IContainer<String> backReferenceableTableNames, String backReferencedFieldName) {
        super(backReferenceableTableNames, backReferencedFieldName);
    }

    @SafeVarargs
    public static <T extends IEntity> MultiBackReference<T> forBackReferencedFieldNameAndBackReferenceableEntityTypes(String backReferencedFieldName, Class<T> ... backReferenceableEntityTypes) {
        ContainerView<Class<String>> backReferenceableEntityTypesContainerView = ContainerView.forArray(backReferenceableEntityTypes);
        IContainer<String> backReferenceableTableNamesView = backReferenceableEntityTypesContainerView.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new MultiBackReference(backReferenceableTableNamesView, backReferencedFieldName);
    }

    public static <T extends IEntity> MultiBackReference<T> forBackReferencedFieldNameAndBackReferenceableEntityTypes(String backReferencedFieldName, IContainer<Class<? extends T>> backReferenceableEntityTypes) {
        IContainer<String> backReferenceableTableNamesView = backReferenceableEntityTypes.getViewOf(TABLE_NAME_EXTRACTOR::getTableNameOfEntityType);
        return new MultiBackReference(backReferenceableTableNamesView, backReferencedFieldName);
    }

    public static <T extends IEntity> MultiBackReference<T> forBackReferencedFieldNameAndBackReferenceableTableNames(String backReferencedFieldName, IContainer<String> backReferenceableTableNames) {
        return new MultiBackReference(backReferenceableTableNames, backReferencedFieldName);
    }

    @Override
    public IContainer<String> getAllBackReferencedEntityIds() {
        this.updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getViewOfStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrLoadedOrEdited).to(IMultiBackReferenceEntry::getBackReferencedEntityId);
    }

    @Override
    public IContainer<E> getAllStoredBackReferencedEntities() {
        this.updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded();
        return this.localEntries.getViewOfStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrLoadedOrEdited).to(IMultiBackReferenceEntry::getStoredBackReferencedEntity);
    }

    @Override
    public IContainer<? extends IMultiBackReferenceEntry<E>> getStoredNewAndDeletedEntries() {
        return this.localEntries.getStoredSelected(DATABASE_OBJECT_EXAMINER::isNewOrDeleted);
    }

    @Override
    public IContainer<IBaseReference> getStoredBackReferencedBaseReferences() {
        LinkedList<IBaseReference> abstractReferences = LinkedList.createEmpty();
        String backReferencedBaseReferenceName = this.getBackReferencedFieldName();
        for (IEntity e : this.getAllStoredBackReferencedEntities()) {
            IBaseReference backReferencedField = (IBaseReference)ENTITY_SEARCHER.getStoredFieldByName(e, backReferencedBaseReferenceName);
            abstractReferences.addAtEnd(backReferencedField);
        }
        return abstractReferences;
    }

    @Override
    public FieldType getType() {
        return FieldType.MULTI_BACK_REFERENCE;
    }

    @Override
    public void internalSetNullableValue(Object nullableValue, String nullableAdditionalValue) {
    }

    @Override
    public boolean isEmpty() {
        return this.localEntries.isEmpty() && this.isEmptyWhenDoesNotHaveLocalEntries();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getAllStoredBackReferencedEntities().iterator();
    }

    @Override
    public boolean loadedAllPersistedReferencedEntityIds() {
        return this.loadedAllPersistedBackReferencedEntityIds;
    }

    @Override
    public boolean referencesBackField(IField field) {
        return field != null && field.belongsToEntity() && this.getBackReferencedFieldName().equals(field.getName()) && this.referencesBackEntity((IEntity)field.getStoredParentEntity());
    }

    @Override
    public boolean referencesBackEntity(IEntity entity) {
        String entityId = entity.getId();
        return this.referencesBackEntityWithId(entityId);
    }

    @Override
    public boolean referencesBackEntityWithId(String id) {
        return this.getAllBackReferencedEntityIds().containsEqualing(id);
    }

    void internalAddBackReferencedEntity(IEntity backReferencedEntity) {
        MultiBackReferenceEntry<IEntity> newEntry = MultiBackReferenceEntry.createNewEntryForMultiBackReferenceAndBackReferencedEntity(this, backReferencedEntity);
        this.localEntries.addAtEnd(newEntry);
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    void deleteEntryByBackReferencedEntityId(String backReferencedEntityId) {
        MultiBackReferenceEntry entry = this.localEntries.getStoredFirst(e -> e.getBackReferencedEntityId().equals(backReferencedEntityId));
        entry.setDeleted();
        this.setAsEditedAndRunPossibleUpdateAction();
    }

    private boolean isEmptyWhenDoesNotHaveLocalEntries() {
        return this.getAllStoredBackReferencedEntities().isEmpty();
    }

    private IContainer<MultiBackReferenceEntry<E>> loadAllPersistedEntries() {
        Object parentTable = this.getStoredParentTable();
        String tableId = parentTable.getId();
        String tableName = parentTable.getName();
        TableIdentification table = new TableIdentification(tableId, tableName);
        String entityId = this.getStoredParentEntity().getId();
        IColumn parentColumn = this.getStoredParentColumn();
        String columnId = parentColumn.getId();
        String columnName = parentColumn.getName();
        ColumnIdentification multiBackReferenceColumn = new ColumnIdentification(columnId, columnName);
        IContainer<MultiBackReferenceEntryDto> multiBackReferenceEntries = this.getStoredDataAndSchemaAdapter().loadMultiBackReferenceEntries(table, entityId, multiBackReferenceColumn);
        return multiBackReferenceEntries.getViewOf(e -> MultiBackReferenceEntryMapper.mapMultiBackReferenceEntryDtoToLoadedMultiBackReferenceEntry(e, this));
    }

    private boolean needsToLoadAllPersistedBackReferencedEntityIds() {
        return !this.loadedAllPersistedReferencedEntityIds() && FIELD_EXAMINER.belongsToLoadedEntity(this);
    }

    private void updateStateLoadingAllPersistedBackReferencedEntityIds() {
        this.loadedAllPersistedBackReferencedEntityIds = true;
        this.localEntries.addAtEnd(this.loadAllPersistedEntries());
    }

    private void updateStateLoadingAllPersistedBackReferencedEntityIdsIfNotLoaded() {
        if (this.needsToLoadAllPersistedBackReferencedEntityIds()) {
            this.updateStateLoadingAllPersistedBackReferencedEntityIds();
        }
    }
}

