/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.modelsearcher;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.fieldexaminer.FieldExaminer;
import ch.nolix.systemapi.databaseobject.request.EditingRequestable;
import ch.nolix.systemapi.objectdata.fieldexaminer.IFieldExaminer;
import ch.nolix.systemapi.objectdata.model.IBaseBackReference;
import ch.nolix.systemapi.objectdata.model.IBaseReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class EntitySearcher
implements IEntitySearcher {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();

    @Override
    public Optional<IBaseBackReference> getOptionalStoredBaseBackReferenceWhoCanBackReferenceTheBaseReference(IEntity entity, IBaseReference baseReference) {
        if (entity != null && baseReference != null) {
            for (IField iField : entity.internalGetStoredFields()) {
                if (!FIELD_EXAMINER.canReferenceBackBaseReference(iField, baseReference)) continue;
                return Optional.of((IBaseBackReference)iField);
            }
        }
        return Optional.empty();
    }

    @Override
    public IContainer<IBaseBackReference> getStoredBaseBackReferencesThatReferenceBackEntity(IEntity entity) {
        IContainer<? extends IField> fields = entity.internalGetStoredFields();
        return fields.toMultiples(IField::getStoredBaseBackReferencesWhoReferencesBackThis);
    }

    @Override
    public IContainer<? extends IField> getStoredEditedFields(IEntity entity) {
        return entity.internalGetStoredFields().getStoredSelected(EditingRequestable::isEdited);
    }

    @Override
    public IField getStoredFieldByName(IEntity entity, String name) {
        IContainer<? extends IField> fields = entity.internalGetStoredFields();
        return fields.getStoredFirst(f -> f.hasName(name));
    }

    @Override
    public IContainer<IBaseReference> getStoredFieldsWhoAreBackReferencedFromEntity(IEntity entity) {
        IContainer<? extends IField> fields = entity.internalGetStoredFields();
        return fields.toMultiples(IField::getStoredBackReferencedBaseReferences);
    }
}

