/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.persistence;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.middatamodelmapper.EntityDtoMapper;
import ch.nolix.system.objectdata.persistence.MultiFieldSaver;
import ch.nolix.systemapi.databaseobject.property.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.EntityCreationDto;
import ch.nolix.systemapi.middata.model.EntityDeletionDto;
import ch.nolix.systemapi.middata.model.EntityUpdateDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IEntityDtoMapper;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.perstistence.IEntitySaver;
import ch.nolix.systemapi.objectdata.perstistence.IMultiFieldSaver;

public final class EntitySaver
implements IEntitySaver {
    private static final IEntityDtoMapper ENTITY_DTO_MAPPER = new EntityDtoMapper();
    private static final IMultiFieldSaver MULTI_FIELD_SAVER = new MultiFieldSaver();

    @Override
    public void saveEntityChanges(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState entityState = (DatabaseObjectState)((Object)entity.getState());
        switch (entityState) {
            case NEW: {
                this.saveEntityCreation(entity, dataAndSchemaAdapter);
                break;
            }
            case UNEDITED: {
                break;
            }
            case EDITED: {
                this.saveEntityUpdates(entity, dataAndSchemaAdapter);
                break;
            }
            case DELETED: {
                this.saveEntityDeletion(entity, dataAndSchemaAdapter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName((Object)entityState, "entity state");
            }
        }
    }

    @Override
    public void saveEntityCreation(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        String tableName = ((ITable)entity.getStoredParentTable()).getName();
        EntityCreationDto entityCreationDto = ENTITY_DTO_MAPPER.mapEntityToEntityCreationDto(entity);
        dataAndSchemaAdapter.insertEntity(tableName, entityCreationDto);
        MULTI_FIELD_SAVER.saveMultiFieldChangesOfEntity(entity, dataAndSchemaAdapter);
    }

    @Override
    public void saveEntityDeletion(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        String tableName = ((ITable)entity.getStoredParentTable()).getName();
        EntityDeletionDto entityDeletionDto = ENTITY_DTO_MAPPER.mapEntityToEntityDeletionDto(entity);
        dataAndSchemaAdapter.deleteEntity(tableName, entityDeletionDto);
        MULTI_FIELD_SAVER.saveMultiFieldChangesOfEntity(entity, dataAndSchemaAdapter);
    }

    @Override
    public void saveEntityUpdates(IEntity entity, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        String tableName = ((ITable)entity.getStoredParentTable()).getName();
        EntityUpdateDto entityUpdateDto = ENTITY_DTO_MAPPER.mapEntityToEntityUpdateDto(entity);
        dataAndSchemaAdapter.updateEntity(tableName, entityUpdateDto);
        MULTI_FIELD_SAVER.saveMultiFieldChangesOfEntity(entity, dataAndSchemaAdapter);
    }
}

