/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectschema.model;

import ch.nolix.system.objectschema.midschemamodelmapper.ColumnDtoMapper;
import ch.nolix.system.objectschema.model.Column;
import ch.nolix.system.objectschema.model.Table;
import ch.nolix.systemapi.midschema.adapter.ISchemaAdapter;
import ch.nolix.systemapi.midschema.model.ColumnDto;
import ch.nolix.systemapi.midschema.structure.TableIdentification;
import ch.nolix.systemapi.objectschema.midschemamodelmapper.IColumnDtoMapper;

public final class TableEditor {
    private static final IColumnDtoMapper COLUMN_DTO_MAPPER = new ColumnDtoMapper();

    private TableEditor() {
    }

    public static void addColumnToTable(Table table, Column column) {
        table.addColumnAttribute(column);
        column.setParentTableAttribute(table);
        if (table.isConnectedWithRealDatabase()) {
            ISchemaAdapter midSchemaAdapter = table.getStoredMidSchemaAdapter();
            String tableId = table.getId();
            String tableName = table.getName();
            TableIdentification tableIdentification = new TableIdentification(tableId, tableName);
            ColumnDto columnDto = COLUMN_DTO_MAPPER.mapColumnToMidSchemaColumnDto(column);
            midSchemaAdapter.addColumn(tableIdentification, columnDto);
        }
        table.setEdited();
    }

    public static void deleteTable(Table table) {
        if (table.belongsToDatabase()) {
            table.getStoredParentDatabase().removeTableAttribute(table);
        }
        String tableName = table.getName();
        table.getStoredMidSchemaAdapter().deleteTable(tableName);
        table.setDeleted();
    }

    public static void setNameToTable(Table table, String name) {
        String oldName = table.getName();
        table.setNameAttribute(name);
        table.setEdited();
        if (table.isConnectedWithRealDatabase()) {
            table.getStoredMidSchemaAdapter().renameTable(oldName, name);
        }
    }
}

