/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.base;

import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.target.IApplicationInstanceTarget;
import ch.nolix.coreapi.web.cookie.ICookieManager;
import ch.nolix.system.application.main.AbstractBackendClient;
import ch.nolix.system.webapplication.base.FileReader;
import ch.nolix.system.webapplication.base.RequestCreator;
import ch.nolix.system.webapplication.protocol.ClientCommandCreator;
import java.util.Optional;

public abstract class AbstractWebClient<C extends AbstractWebClient<C, S>, S>
extends AbstractBackendClient<C, S>
implements ICookieManager {
    private static final ClientCommandCreator BACKEND_WEB_CLIENT_COMMAND_CREATOR = new ClientCommandCreator();
    private final FileReader fileReader = FileReader.forBackendWebClient(this);

    @Override
    public final void deleteCookieByName(String name) {
        IChainedNode deleteCookieCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createDeleteCookieCommand(name);
        this.runOnCounterpart(deleteCookieCommand);
    }

    @Override
    public final Optional<String> getOptionalCookieValueByCookieName(String cookieName) {
        ChainedNode getCookieValueRequest = RequestCreator.createGetCookieValueRequestForCookieName(cookieName);
        return this.getOptionalCookieValueByCookieNameFromData(this.getDataFromCounterpart(getCookieValueRequest));
    }

    public final Optional<String> getOptionalUrlParameterValueByUrlParameterName(String urlParameterName) {
        ChainedNode getUrlParameterValueRequest = RequestCreator.createGetUrlParameterValueRequestForUrlParameterName(urlParameterName);
        INode<?> urlParameterValueReply = this.getDataFromCounterpart(getUrlParameterValueRequest);
        return urlParameterValueReply.getOptionalHeader();
    }

    @Override
    public final void setOrAddCookieWithNameAndValue(String name, String value) {
        IChainedNode addOrSetCookieCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createAddOrSetCookieCommand(name, value);
        this.runOnCounterpart(addOrSetCookieCommand);
    }

    @Override
    protected final void runHere(IChainedNode command) {
        switch (command.getHeader()) {
            case "ReceiveOptionalFile": {
                this.receiveOptionalFileFromCounterpart(command);
                break;
            }
            default: {
                this.runHereOnBaseBackendWebClient(command);
            }
        }
    }

    protected abstract void runHereOnBaseBackendWebClient(IChainedNode var1);

    final IContainer<byte[]> internalGetFilesFromClipboardOfCounterpart() {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "getFilesFromClipboard");
    }

    final String internalGetTextFromClipboardOfCounterpart() {
        ChainedNode getTextFromClipBoardCommand = RequestCreator.createGetTextFromClipboardRequest();
        return this.getDataFromCounterpart(getTextFromClipBoardCommand).getHeader();
    }

    final void internalOpenNewTabOnCounterpartWithUrl(String url) {
        IChainedNode openNewTabCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createOpenNewTabCommand(url);
        this.runOnCounterpart(openNewTabCommand);
    }

    final Optional<byte[]> internalReadOptionalFileFromCounterpart() {
        return this.fileReader.readOptionalFileFromCounterpart();
    }

    final void internalRedirectCounterpartTo(IApplicationInstanceTarget applicationInstanceTarget) {
        IChainedNode redirectCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createRedirectCommand(applicationInstanceTarget);
        this.runOnCounterpart(redirectCommand);
    }

    final void internalRedirectCounterpartToUrl(String url) {
        IChainedNode redirectToUrlCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createRedirectCommand(url);
        this.runOnCounterpart(redirectToUrlCommand);
    }

    final void internalRunOnCounterpart(ChainedNode command) {
        this.runOnCounterpart((IChainedNode)command);
    }

    final void internalSaveFileOnCounterpart(byte[] bytes) {
        IChainedNode saveFileCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createSaveFileCommand(bytes);
        this.runOnCounterpart(saveFileCommand);
    }

    final void internalWriteTextToClipboardOfCounterpart(String text) {
        IChainedNode writeTextToClipboardCommand = BACKEND_WEB_CLIENT_COMMAND_CREATOR.createWriteTextToClipBoardCommand(text);
        this.runOnCounterpart(writeTextToClipboardCommand);
    }

    private Optional<String> getOptionalCookieValueByCookieNameFromData(INode<?> data) {
        return data.getOptionalHeader();
    }

    private void receiveOptionalFileFromCounterpart(IChainedNode receiveOptionalFileCommand) {
        this.fileReader.receiveOptionalFileFromCounterpart(receiveOptionalFileCommand);
    }
}

