/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.base;

import ch.nolix.core.document.chainednode.ChainedNode;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.system.webapplication.base.AbstractWebClient;
import java.util.Base64;
import java.util.Optional;

final class FileReader {
    private static final int MAX_WAITING_TIME_FOR_FILE_FROM_COUNTERPART_IN_SECONDS = 60;
    private final AbstractWebClient<?, ?> parentBackendWebClient;
    private boolean isWaitingForFileFromCounterpart;
    private byte[] latestOptionalFileFromCounterpart;

    private FileReader(AbstractWebClient<?, ?> parentBackendWebClient) {
        Validator.assertThat(parentBackendWebClient).thatIsNamed("parent backend web client").isNotNull();
        this.parentBackendWebClient = parentBackendWebClient;
    }

    public static FileReader forBackendWebClient(AbstractWebClient<?, ?> backendWebClient) {
        return new FileReader(backendWebClient);
    }

    public Optional<byte[]> readOptionalFileFromCounterpart() {
        this.assertIsNotWaitingForFileFromCounterpart();
        return this.readOptionalFileFromCounterpartWhenIsNotWaitingForFileFromCounterpart();
    }

    public void receiveOptionalFileFromCounterpart(IChainedNode receiveOptionalFileCommand) {
        switch (receiveOptionalFileCommand.getChildNodeCount()) {
            case 0: {
                this.receiveEmptyFileSelectionFromCounterpart();
                break;
            }
            case 1: {
                String fileString = receiveOptionalFileCommand.getSingleChildNode().getHeader();
                byte[] file = Base64.getDecoder().decode(fileString.substring(fileString.indexOf(44) + 1));
                this.receiveFileFromCounterpart(file);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName(receiveOptionalFileCommand, "receive optional file commoand");
            }
        }
    }

    private void assertIsNotWaitingForFileFromCounterpart() {
        if (this.isWaitingForFileFromCounterpart()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is already waiting for a file from the counterpart");
        }
    }

    private void assertIsWaitingForFileFromCounterpart() {
        if (!this.isWaitingForFileFromCounterpart()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not waiting for a file from counterpart");
        }
    }

    private boolean isWaitingForFileFromCounterpart() {
        return this.isWaitingForFileFromCounterpart;
    }

    private Optional<byte[]> readOptionalFileFromCounterpartWhenIsNotWaitingForFileFromCounterpart() {
        try {
            this.isWaitingForFileFromCounterpart = true;
            this.parentBackendWebClient.internalRunOnCounterpart(ChainedNode.withHeader("SendOptionalFile"));
            FlowController.forMaxSeconds(60).waitAsLongAs(this::isWaitingForFileFromCounterpart);
            Optional<byte[]> optional = Optional.ofNullable(this.latestOptionalFileFromCounterpart);
            return optional;
        }
        finally {
            this.isWaitingForFileFromCounterpart = false;
        }
    }

    private void receiveEmptyFileSelectionFromCounterpart() {
        this.assertIsWaitingForFileFromCounterpart();
        this.isWaitingForFileFromCounterpart = false;
        this.latestOptionalFileFromCounterpart = null;
    }

    private void receiveFileFromCounterpart(byte[] file) {
        Validator.assertThat(file).thatIsNamed("file").isNotNull();
        this.assertIsWaitingForFileFromCounterpart();
        this.isWaitingForFileFromCounterpart = false;
        this.latestOptionalFileFromCounterpart = file;
    }
}

