/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.refreshqueue;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IWebGui;

public final class UpdateTicket {
    private final boolean updateConstellationOrStyle;
    private final IWebGui<?> webGui;
    private final ImmutableList<IControl<?, ?>> controls;

    private UpdateTicket(IWebGui<?> webGui, boolean updateConstellationOrStyle) {
        Validator.assertThat(webGui).thatIsNamed(IWebGui.class).isNotNull();
        this.updateConstellationOrStyle = updateConstellationOrStyle;
        this.webGui = webGui;
        this.controls = null;
    }

    private UpdateTicket(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        this.updateConstellationOrStyle = updateConstellationOrStyle;
        this.webGui = null;
        this.controls = ImmutableList.fromIterable(controls);
    }

    public static UpdateTicket forControls(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        return new UpdateTicket(controls, updateConstellationOrStyle);
    }

    public static UpdateTicket forWebGui(IWebGui<?> webGui, boolean updateConstellationOrStyle) {
        return new UpdateTicket(webGui, updateConstellationOrStyle);
    }

    public IContainer<IControl<?, ?>> getStoredControls() {
        this.assertIsForSpecificControls();
        return this.controls;
    }

    public IWebGui<?> getStoredWebGui() {
        this.assertIsForWholeWebGui();
        return this.webGui;
    }

    public boolean isForWholeWebGui() {
        return this.webGui != null;
    }

    public boolean isForSpecificControls() {
        return !this.isForWholeWebGui();
    }

    public boolean shouldUpdateConstellationOrStyle() {
        return this.updateConstellationOrStyle;
    }

    private void assertIsForSpecificControls() {
        if (!this.isForSpecificControls()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not for specifici controls");
        }
    }

    private void assertIsForWholeWebGui() {
        if (!this.isForWholeWebGui()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not for whole web GUI");
        }
    }
}

