/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webapplication.refreshqueue;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.chainednode.IChainedNode;
import ch.nolix.system.webapplication.counterpartupdater.WebClientCounterpartUpdater;
import ch.nolix.system.webapplication.counterpartupdater.WebClientPartialCounterpartUpdater;
import ch.nolix.system.webapplication.refreshqueue.UpdateTicket;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IWebGui;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public final class WebClientRefreshQueue {
    private final BooleanSupplier openStateRequestable;
    private final Consumer<IContainer<? extends IChainedNode>> counterpartRunner;
    private boolean updatingCounterpart;
    private UpdateTicket memberUpdateTicket;

    private WebClientRefreshQueue(Consumer<IContainer<? extends IChainedNode>> counterpartRunner, BooleanSupplier openStateRequestable) {
        Validator.assertThat(openStateRequestable).thatIsNamed("open state requestable").isNotNull();
        Validator.assertThat(counterpartRunner).thatIsNamed("counterpart runner").isNotNull();
        this.openStateRequestable = openStateRequestable;
        this.counterpartRunner = counterpartRunner;
    }

    public static WebClientRefreshQueue forCounterpartRunnerAndOpenStateRequestable(Consumer<IContainer<? extends IChainedNode>> counterpartRunner, BooleanSupplier openStateRequester) {
        return new WebClientRefreshQueue(counterpartRunner, openStateRequester);
    }

    public void updateControlOnCounterpart(IControl<?, ?> control, boolean updateConstellationOrStyle) {
        ImmutableList<IControl<?, ?>> controls = ImmutableList.withElements(control);
        this.updateControlsOnCounterpart(controls, updateConstellationOrStyle);
    }

    public void updateControlsOnCounterpart(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        this.setUpdatingControlsOnCounterpartAsRequired(controls, updateConstellationOrStyle);
        if (!this.isUpdatingCounterpart()) {
            this.updateCounterpartAsLongAsRequired();
        }
    }

    public void updateWebGuiOfCounterpart(IWebGui<?> webGui, boolean updateConstellationOrStyle) {
        this.setUpdatingWebGuiOfCounterpartAsRequired(webGui, updateConstellationOrStyle);
        if (!this.isUpdatingCounterpart()) {
            this.updateCounterpartAsLongAsRequired();
        }
    }

    private void assertUpdatingCounterpartIsRequired() {
        if (!this.updatingCounterpartIsRequired()) {
            throw GeneralException.withErrorMessage("Updating counterpart is not required.");
        }
    }

    private synchronized UpdateTicket getNextUpdateTicket() {
        this.assertUpdatingCounterpartIsRequired();
        this.updatingCounterpart = true;
        UpdateTicket localUpdateTicket = this.memberUpdateTicket;
        this.memberUpdateTicket = null;
        return localUpdateTicket;
    }

    private LinkedList<IControl<?, ?>> getStoredAllControlsFromUpdateTicketAndGivenControls(IContainer<IControl<?, ?>> controls) {
        LinkedList<IControl<?, ?>> allControls = LinkedList.fromIterable(this.memberUpdateTicket.getStoredControls());
        for (IControl iControl : controls) {
            if (allControls.contains(iControl)) continue;
            allControls.addAtEnd(iControl);
        }
        return allControls;
    }

    private synchronized boolean isUpdatingCounterpart() {
        return this.updatingCounterpart;
    }

    private synchronized void setFinishedUpdateCounterpart() {
        this.updatingCounterpart = false;
    }

    private synchronized void setUpdatingControlsOnCounterpartAsRequired(IContainer<IControl<?, ?>> controls, boolean updateConstellationOrStyle) {
        if (this.updatingCounterpartIsRequired()) {
            if (this.memberUpdateTicket.isForSpecificControls()) {
                LinkedList<IControl<?, ?>> allControls = this.getStoredAllControlsFromUpdateTicketAndGivenControls(controls);
                this.memberUpdateTicket = UpdateTicket.forControls(allControls, updateConstellationOrStyle);
            }
        } else {
            this.memberUpdateTicket = UpdateTicket.forControls(controls, updateConstellationOrStyle);
        }
    }

    private synchronized void setUpdatingWebGuiOfCounterpartAsRequired(IWebGui<?> webGui, boolean updateConstellationOrStyle) {
        if (!this.updatingCounterpartIsRequired() || this.memberUpdateTicket.isForSpecificControls()) {
            this.memberUpdateTicket = UpdateTicket.forWebGui(webGui, updateConstellationOrStyle);
        }
    }

    private void updateCounterpart() {
        UpdateTicket nextUpdateTicket = this.getNextUpdateTicket();
        this.updateCounterpart(nextUpdateTicket);
        this.setFinishedUpdateCounterpart();
    }

    private void updateCounterpart(UpdateTicket updateTicket) {
        if (updateTicket.isForWholeWebGui()) {
            WebClientCounterpartUpdater.forCounterpartRunnerAndOpenStateRequestable(this.counterpartRunner, this.openStateRequestable).updateCounterpartFromWebGui(updateTicket.getStoredWebGui());
        } else {
            WebClientPartialCounterpartUpdater.forCounterpartRunnerAndOpenStateRequestable(this.counterpartRunner, this.openStateRequestable).updateControlsOnCounterpart(updateTicket.getStoredControls(), updateTicket.shouldUpdateConstellationOrStyle());
        }
    }

    private void updateCounterpartAsLongAsRequired() {
        while (this.updatingCounterpartIsRequiredSynchronized()) {
            this.updateCounterpart();
        }
    }

    private boolean updatingCounterpartIsRequired() {
        return this.memberUpdateTicket != null;
    }

    private synchronized boolean updatingCounterpartIsRequiredSynchronized() {
        return this.updatingCounterpartIsRequired();
    }
}

