/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webatomiccontrol.label;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotSupportMethodException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.element.property.MutableOptionalValue;
import ch.nolix.system.element.property.MutableValue;
import ch.nolix.system.webatomiccontrol.label.LabelCssBuilder;
import ch.nolix.system.webatomiccontrol.label.LabelHtmlBuilder;
import ch.nolix.system.webatomiccontrol.label.LabelStyle;
import ch.nolix.system.webgui.main.Control;
import ch.nolix.systemapi.gui.model.CursorIcon;
import ch.nolix.systemapi.webatomiccontrol.label.ILabel;
import ch.nolix.systemapi.webatomiccontrol.label.ILabelStyle;
import ch.nolix.systemapi.webatomiccontrol.label.LabelRole;
import ch.nolix.systemapi.webgui.controltool.IControlCssBuilder;
import ch.nolix.systemapi.webgui.controltool.IControlHtmlBuilder;
import ch.nolix.systemapi.webgui.main.IControl;
import ch.nolix.systemapi.webgui.main.IHtmlElementEvent;
import java.util.Optional;

public final class Label
extends Control<ILabel, ILabelStyle>
implements ILabel {
    public static final String DEFAULT_TEXT = "-";
    private static final String ROLE_HEADER = "Role";
    private static final String TEXT_HEADER = "Text";
    private static final LabelHtmlBuilder HTML_BUILDER = new LabelHtmlBuilder();
    private static final LabelCssBuilder CSS_BUILDER = new LabelCssBuilder();
    private final MutableOptionalValue<LabelRole> memberRole = new MutableOptionalValue<LabelRole>("Role", this::setRole, LabelRole::fromSpecification, Node::fromEnum);
    private final MutableValue<String> text = MutableValue.forString("Text", "-", this::setText);

    public Label() {
        this.reset();
    }

    @Override
    public Optional<String> getOptionalJavaScriptUserInputFunction() {
        return Optional.empty();
    }

    @Override
    public IContainer<IControl<?, ?>> getStoredChildControls() {
        return ImmutableList.createEmpty();
    }

    @Override
    public LabelRole getRole() {
        return (LabelRole)((Object)this.memberRole.getValue());
    }

    @Override
    public String getText() {
        return (String)this.text.getValue();
    }

    @Override
    public String getUserInput() {
        return "";
    }

    @Override
    public boolean hasRole() {
        return this.memberRole.containsAny();
    }

    @Override
    public boolean hasRole(String role) {
        return this.hasRole() && this.getRole().toString().equals(role);
    }

    @Override
    public void registerHtmlElementEventsAt(ILinkedList<IHtmlElementEvent> list) {
    }

    @Override
    public void removeRole() {
        this.memberRole.clear();
    }

    @Override
    public void runHtmlEvent(String htmlEvent) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "runHtmlEvent");
    }

    @Override
    public ILabel setRole(LabelRole role) {
        this.memberRole.setValue(role);
        return this;
    }

    @Override
    public ILabel setText(String text) {
        Validator.assertThat(text).thatIsNamed("text").isNotNull();
        this.text.setValue(text);
        return this;
    }

    @Override
    public ILabel setUserInput(String userInput) {
        throw ArgumentDoesNotSupportMethodException.forArgumentAndMethodName(this, "setUserInput");
    }

    @Override
    protected LabelStyle createStyle() {
        return new LabelStyle();
    }

    @Override
    protected IControlCssBuilder<ILabel, ILabelStyle> getCssBuilder() {
        return CSS_BUILDER;
    }

    @Override
    protected IControlHtmlBuilder<ILabel> getHtmlBuilder() {
        return HTML_BUILDER;
    }

    @Override
    protected void resetControl() {
        this.removeRole();
        this.setText(DEFAULT_TEXT);
        this.setCursorIcon(CursorIcon.EDIT);
    }
}

