/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webcontainercontrol.grid;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.system.element.multistateconfiguration.NonCascadingProperty;
import ch.nolix.system.graphic.color.Color;
import ch.nolix.system.graphic.color.X11ColorCatalog;
import ch.nolix.system.webgui.controlstyle.AbstractControlStyle;
import ch.nolix.systemapi.element.base.IElement;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.systemapi.webcontainercontrol.grid.GridType;
import ch.nolix.systemapi.webcontainercontrol.grid.IGridStyle;
import ch.nolix.systemapi.webgui.main.ControlState;

public final class GridStyle
extends AbstractControlStyle<IGridStyle>
implements IGridStyle {
    public static final GridType DEFAULT_GRID_TYPE = GridType.INNER_LINES;
    public static final int DEFAULT_GRID_THICKNESS = 1;
    public static final Color DEFAULT_GRID_COLOR = X11ColorCatalog.BLACK;
    public static final int DEFAULT_CHILD_CONTROL_MARGIN = 0;
    private static final String GRID_TYPE_HEADER = "GridType";
    private static final String GRID_THICKNESS_HEADER = "GridThickness";
    private static final String GRID_COLOR_HEADER = "GridColor";
    private static final String CHILD_CONTROL_MARGIN_HEADER = "ChildControlMargin";
    private final NonCascadingProperty<ControlState, GridType> gridType = new NonCascadingProperty<ControlState, GridType>("GridType", ControlState.class, GridType::fromSpecification, Node::fromEnum, this::setGridTypeForState, DEFAULT_GRID_TYPE);
    private final NonCascadingProperty<ControlState, Integer> gridThickness = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("GridThickness", ControlState.class, this::setGridThicknessForState, 1);
    private final NonCascadingProperty<ControlState, IColor> gridColor = new NonCascadingProperty<ControlState, Color>("GridColor", ControlState.class, Color::fromSpecification, IElement::getSpecification, this::setGridColorForState, DEFAULT_GRID_COLOR);
    private final NonCascadingProperty<ControlState, Integer> childControlMargin = NonCascadingProperty.forIntWithNameAndStateClassAndSetterMethodAndDefaultValue("ChildControlMargin", ControlState.class, this::setChildControlMarginForState, 0);

    public GridStyle() {
        this.initialize();
    }

    @Override
    public int getChildControlMarginWhenHasState(ControlState state) {
        return (Integer)this.childControlMargin.getValueWhenHasState(state);
    }

    @Override
    public IColor getGridColorWhenHasState(ControlState state) {
        return (IColor)this.gridColor.getValueWhenHasState(state);
    }

    @Override
    public int getGridThicknessWhenHasState(ControlState state) {
        return (Integer)this.gridThickness.getValueWhenHasState(state);
    }

    @Override
    public GridType getGridTypeWhenHasState(ControlState state) {
        return (GridType)((Object)this.gridType.getValueOfState(state));
    }

    @Override
    public void removeCustomChildControlMargins() {
        this.childControlMargin.setUndefined();
    }

    @Override
    public void removeCustomGridColors() {
        this.gridColor.setUndefined();
    }

    @Override
    public void removeCustomGridThicknesses() {
        this.gridThickness.setUndefined();
    }

    @Override
    public void removeCustomGridTypes() {
        this.gridType.setUndefined();
    }

    @Override
    public IGridStyle setChildControlMarginForState(ControlState state, int childControlMargin) {
        Validator.assertThat(childControlMargin).thatIsNamed("child control margin").isNotNegative();
        this.childControlMargin.setValueForState(state, childControlMargin);
        return this;
    }

    @Override
    public IGridStyle setGridColorForState(ControlState state, IColor gridColor) {
        this.gridColor.setValueForState(state, gridColor);
        return this;
    }

    @Override
    public IGridStyle setGridThicknessForState(ControlState state, int gridThickness) {
        Validator.assertThat(gridThickness).thatIsNamed("grid thickness").isNotNegative();
        this.gridThickness.setValueForState(state, gridThickness);
        return this;
    }

    @Override
    public IGridStyle setGridTypeForState(ControlState state, GridType gridType) {
        this.gridType.setValueForState(state, gridType);
        return this;
    }
}

