/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.webgui.main;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.web.htmlelementmodel.HtmlAttribute;
import ch.nolix.core.web.htmlelementmodel.HtmlElement;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlAttribute;
import ch.nolix.coreapi.web.htmlelementmodel.IHtmlElement;
import ch.nolix.systemapi.webgui.main.ILayer;

public final class LayerHtmlBuilder {
    private LayerHtmlBuilder() {
    }

    public static IHtmlElement getHtmlElementForLayer(ILayer<?> layer) {
        return HtmlElement.withTypeAndAttributesAndChildElements("div", LayerHtmlBuilder.getHtmlAttributesForLayer(layer), LayerHtmlBuilder.getHtmlChildElementsForLayer(layer));
    }

    private static IContainer<IHtmlAttribute> getHtmlAttributesForLayer(ILayer<?> layer) {
        IHtmlAttribute idHtmlAttribute = LayerHtmlBuilder.createIdHtmlAttributeForLayer(layer);
        return ImmutableList.withElements(idHtmlAttribute);
    }

    public static IHtmlAttribute createIdHtmlAttributeForLayer(ILayer<?> layer) {
        return HtmlAttribute.withNameAndValue("id", layer.getInternalId());
    }

    private static IContainer<IHtmlElement> getHtmlChildElementsForLayer(ILayer<?> layer) {
        if (layer.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        return ImmutableList.withElements(LayerHtmlBuilder.getContentHtmlElementForLayer(layer));
    }

    private static IHtmlElement getContentHtmlElementForLayer(ILayer<?> layer) {
        return layer.getStoredRootControl().getHtml();
    }
}

