/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.tech.math.fractal;

import ch.nolix.system.graphic.color.Color;
import ch.nolix.systemapi.graphic.color.IColor;
import ch.nolix.tech.math.bigdecimalmath.ClosedInterval;
import ch.nolix.tech.math.bigdecimalmath.ComplexSequenceDefinedBy1Predecessor;
import ch.nolix.tech.math.fractal.Fractal;
import ch.nolix.techapi.math.bigdecimalmath.IClosedInterval;
import ch.nolix.techapi.math.bigdecimalmath.IComplexNumber;
import ch.nolix.techapi.math.bigdecimalmath.ISequence;
import ch.nolix.techapi.math.fractal.IFractalBuilder;
import java.math.BigDecimal;
import java.util.function.Function;
import java.util.function.IntFunction;

public final class FractalBuilder
implements IFractalBuilder {
    public static final IClosedInterval DEFAULT_REAL_COMPONENT_INTERVAL = new ClosedInterval(-2.5, 1.0);
    public static final IClosedInterval DEFAULT_IMAGINARY_COMPONENT_INTERVAL = new ClosedInterval(-1.5, 1.5);
    public static final int DEFAULT_WIDHT_IN_PIXEL = 500;
    public static final int DEFAULT_HEIGHT_IN_PIXEL = 500;
    public static final Function<IComplexNumber, ISequence<IComplexNumber>> DEFAULT_SEQUENCE_CREATOR = z -> ComplexSequenceDefinedBy1Predecessor.withFirstValueAndNextValueFunction(z, p -> p.getPower2().getSum((IComplexNumber)z));
    public static final double DEFAULT_SEQUENCES_MIN_DIVERGENCE_MAGNITUDE = 10.0;
    public static final int DEFAULT_SEQUENCE_MAX_ITERATION_COUNT = 50;
    public static final IntFunction<IColor> DEFAULT_COLOR_FUNCTION = i -> Color.withRedValueAndGreenValueAndBlueValue(0, 0, 10 * i % 255);
    public static final int DEFAULT_BIG_DECIMAL_SCALE = 10;
    private IClosedInterval realComponentInterval = DEFAULT_REAL_COMPONENT_INTERVAL;
    private IClosedInterval imaginaryComponentInterval = DEFAULT_IMAGINARY_COMPONENT_INTERVAL;
    private int widthInPixel = 500;
    private int heightInPixel = 500;
    private Function<IComplexNumber, ISequence<IComplexNumber>> sequenceCreator = DEFAULT_SEQUENCE_CREATOR;
    private BigDecimal sequencesMinDivergenceMagnitude = BigDecimal.valueOf(10.0);
    private int sequencesMaxIterationCount = 50;
    private IntFunction<IColor> colorFunction = DEFAULT_COLOR_FUNCTION;
    private int decimalPlaces = 10;

    @Override
    public Fractal build() {
        return new Fractal(this.realComponentInterval, this.imaginaryComponentInterval, this.widthInPixel, this.heightInPixel, this.sequenceCreator, this.sequencesMinDivergenceMagnitude, this.sequencesMaxIterationCount, this.colorFunction, this.decimalPlaces);
    }

    @Override
    public int getMaxIterationCount() {
        return this.sequencesMaxIterationCount;
    }

    @Override
    public IFractalBuilder setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    @Override
    public IFractalBuilder setColorFunction(IntFunction<IColor> colorFunction) {
        this.colorFunction = colorFunction;
        return this;
    }

    @Override
    public IFractalBuilder setHeightInPixel(int heightInPixel) {
        this.heightInPixel = heightInPixel;
        return this;
    }

    @Override
    public IFractalBuilder setImaginaryComponentInterval(double min, double max) {
        return this.setImaginaryComponentInterval(new ClosedInterval(min, max));
    }

    @Override
    public IFractalBuilder setImaginaryComponentInterval(IClosedInterval imaginaryComponentInterval) {
        this.imaginaryComponentInterval = imaginaryComponentInterval;
        return this;
    }

    @Override
    public IFractalBuilder setRealComponentInterval(double min, double max) {
        return this.setRealComponentInterval(new ClosedInterval(min, max));
    }

    @Override
    public IFractalBuilder setRealComponentInterval(IClosedInterval realComponentInterval) {
        this.realComponentInterval = realComponentInterval;
        return this;
    }

    @Override
    public IFractalBuilder setMaxIterationCount(int sequencesMaxIterationCount) {
        this.sequencesMaxIterationCount = sequencesMaxIterationCount;
        return this;
    }

    @Override
    public IFractalBuilder setMinMagnitudeForDivergence(BigDecimal sequencesMinDivergenceMagnitude) {
        this.sequencesMinDivergenceMagnitude = sequencesMinDivergenceMagnitude;
        return this;
    }

    @Override
    public IFractalBuilder setMinMagnitudeForDivergence(double minMagnitudeForDivergence) {
        return this.setMinMagnitudeForDivergence(BigDecimal.valueOf(minMagnitudeForDivergence));
    }

    @Override
    public IFractalBuilder setSequenceCreator(Function<IComplexNumber, ISequence<IComplexNumber>> sequenceCreator) {
        this.sequenceCreator = sequenceCreator;
        return this;
    }

    @Override
    public IFractalBuilder setWidthInPixel(int widthInPixel) {
        this.widthInPixel = widthInPixel;
        return this;
    }
}

